package IMPL::Config::Container;
use strict;

use IMPL::lang qw(:base);
use IMPL::declare {
	require => {
		Descriptor => 'IMPL::Config::Descriptor'
	},
	base => [
		'IMPL::Object' => undef
	],
	props => [
		roles => 'r',
		services => 'r',
		instances => 'r'
	]
};

my $nextRoleId = 1;

use IMPL::Exception();

sub Register {
	my ($this, $role, $service) = @_;
	
	die IMPL::InvalidArgumentException->new(role => 'The argument is required') unless $role;
	die IMPL::InvalidArgumentException->new('service') unless is($service, Descriptor);
	
	if (isarray($role)) {
        my $tempRole = "unnamed-" . $nextRoleId++;
        $this->role->AddRole($tempRole, $role);
        $role = $tempRole;
	}
	
	$this->services->Register($role, $service);
	
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Config::Container> - dependency injection container

=head1 SYNOPSIS

=head2 METHODS

=head3 GetService($serviceId)

=over

=item * $serviceId

A string indetifier of the service, it can be in two forms: class name or service name,
for the class name it should be prefixed with C<@>, for example: C<@Foo::Bar>.

=back

The activation container maintains two maps, one for classes and the other for names.
The first one is useful when we searching for an implementation the second one when
we need a particular service. 

=head3 RegisterService($descriptor)

=cut
