package IMPL::Web::ViewResult;
use strict;

use IMPL::Const qw(:prop);

use IMPL::declare {
    base => [
        'IMPL::Object' => undef,
        'IMPL::Object::Autofill' => '@_'
    ],
    props => [
        model => PROP_RW,
        location => PROP_RW,
        cookies => PROP_RW,
        headers => PROP_RW,
        status  => PROP_RW
    ]
};

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::ViewResult> - описание представления результата.

=head1 SYNOPSIS

=begin code

sub HttpGet {
    my ($this, $action) = @_;
    
    return IMPL::Web::ViewResult->new(
        model => $model,
        location => $this->location
    );
}

=end code

=head1 DESCRIPTION

Сожержит в себе информацию для представления модели.

=head1 MEMBERS

=head2 C<[get,set]model>

Модель ресурса, как правило это результат выполнения C<Http> метода.

=head2 C<[get,set]location>

Текущий абсолютный адрес ресурса.

=head2 C<[get,set]cookies>

Хеш с печеньками, которые будут добавлены в C<HTTP> ответ.

=head2 C<[get,set]headers>

Заголовки которые нужно добавить в заголовки C<HTTP> ответа.

=head2 C<[get,set]status>

Код C<HTTP> ответа. 

=cut
