package Form::Filter::Depends;
use base qw(Form::Filter);

use Common;

BEGIN {
    DeclareProperty Fields => ACCESS_READ;
}

sub SUPPORTED_CONTEXT { Form::Filter::CTX_SINGLE | Form::Filter::CTX_SET }

sub CTOR {
    my ($this,$name,$message,@fields) = @_;
    
    $this->SUPER::CTOR($name,$message);
    $this->{$Fields} = \@fields;
}

sub Invoke {
    my ($this,$object,$context,$schemaTarget) = @_;

    foreach my $field (@{$this->{$Fields}}) {
        my $objProv = $object->Navigate($object->Form->MakeItemId($field,$object->Parent));

        if ( not $objProv or $objProv->isEmpty ) {
            return new Form::FilterResult(State => Form::FilterResult::STATE_STOP);
        }

    }

    return new Form::FilterResult(State => Form::FilterResult::STATE_SUCCESS_STAY);
}

1;