package IMPL::ORM;
use strict;
use warnings;

use parent qw(IMPL::Object);
use IMPL::Class::Property;
use Scalar::Util qw(weaken refaddr);

use IMPL::Exception;

our $Depth = 1; # загружать объект + 1 уровень детей
our $UseProxy = 1;

BEGIN {
    private property _ObjectCache => prop_all;
    private property _MapInstances => prop_all;
    private property _WorkUnit => prop_all;
    public property Schema => prop_all;
}

sub ObjectInfoById {
    my ($this,$oid) = @_;
    
    return $this->_ObjectCache->{$oid};
}

sub ObjectInfo {
    my ($this,$inst) = @_;
    
    die new IMPL::InvalidOperationException("This method can be used only for a reference") unless ref $inst;
    
    return $this->_MapInstances->{refaddr $inst};
}


1;
__END__

=pod

=head1 NAME

C<IMPL::ORM> - Object Relational Mapping

=head1 SYNOPSIS

=begin code

my $ds = IMPL::ORM::Storage::DBIC->new('My::Data',$dsn,$user,$pass,{Autocommit => 1});


my $foo = $ds->Insert(
    My::Data::Foo->new(
        'foo class'
    )
);

my $bar = $ds->Insert(
    My::Data::Bar->new(
        'bar class'
    )
)

$bar->fooObject($foo);

$ds->Save($bar);

my $fooOther = $ds->Retrieve(
    'My::Data::Bar',
    {
        name =>  'bar class',
        fooObject => {
            name => 'some foo'
        }
    }
)

=end code

=head1 DESCRIPTION

=cut
