package IMPL::Test;
use strict;
use warnings;

require IMPL::Test::SkipException;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(&test &shared &failed &cmparray &skip);

require IMPL::Test::Unit;
use IMPL::Class::Member;

sub test($$) {
    my ($name,$code) = @_;
    my $class = caller;
    
    $class->set_meta(
        new IMPL::Test::Unit::TestInfo( $name, $code )
    );
}

sub shared($) {
    my ($propInfo) = @_;
    
    my $class = caller;
    
    die new IMPL::Exception("Only properties could be declared as shared",$propInfo->Name) unless eval {$propInfo->isa('IMPL::Class::PropertyInfo')};
    die new IMPL::Exception("You can't mark the readonly property as shared",$propInfo->Name) unless $propInfo->canSet;
    die new IMPL::Exception("Only public properties could be declared as shared",$propInfo->Name) unless $propInfo->Access == IMPL::Class::Member::MOD_PUBLIC;
    
    $class->set_meta(new IMPL::Test::Unit::SharedData($propInfo->Name));
}

sub failed($;@) {
    die new IMPL::Test::FailException(@_);
}

sub skip($;@) {
	die new IMPL::Test::SkipException(@_);
}

sub cmparray {
    my ($a,$b) = @_;
    
    return 0 unless @$a == @$b;
    
    for (my $i=0; $i < @$a; $i++ ) {
        return 0 unless $a->[$i] eq $b->[$i];
    }
    
    return 1;
}
1;
