package IMPL::DOM::Schema::Property;
use strict;
use warnings;

use IMPL::declare {
	require => {
		Label => 'IMPL::DOM::Schema::Label',
		DOMNode => 'IMPL::DOM::Node',
		ValidationError => 'IMPL::DOM::Schema::ValidationError'
	},
	base => [
		'IMPL::DOM::Schema::SimpleNode' => sub {
	        my %args = @_;
	        
	        $args{maxOccur} = 1;
	        $args{minOccur} = delete $args{optional} ? 0 : 1;
	        $args{nodeName} ||= 'Property';
	        
	        return %args;
	    }
	],
	props => [
		messageRequired => { get => 1, set => 1, dom => 1 }
	]
};

sub CTOR {
    my ($this,%args) = @_;
    
    $this->messageRequired($args{messageRequired} || 'A property %schemaNode.name% is required in the %node.qname%');
}

sub Validate {
    my ($this,$node,$ctx) = @_;
    
    my $nodeValue = $node->nodeProperty($this->name);
        
    if (length $nodeValue) {
    	# we have a value so validate it
    	
    	# buld a pseudo node for the property value 	
    	my $nodeProp = DOMNode->new(nodeName => '::property', nodeValue => $nodeValue);
        
        return $this->SUPER::Validate($nodeProp);
        
    } elsif($this->minOccur) {
        # we don't have a value but it's a mandatory property
        return ValidationError->new(
            message => $this->_MakeLabel($this->messageRequired),
            node => $node,
            schemaNode => $this
        );
    }
    return ();
}

sub _MakeLabel {
	my ($this,$label) = @_;
	
	if ($label =~ /^ID:(\w+)$/) {
		return Label->new($this->document->stringMap, $1);
	} else {
		return $label;
	}
}

1;
