package IMPL::Web::Handler::LocaleHandler;
use strict;

use IMPL::Const qw(:prop);
use IMPL::declare {
	require => {
		Resources => 'IMPL::Resources'
	},
	base => [
		'IMPL::Object' => undef,
		'IMPL::Object::Autofill' => '@_',
		'IMPL::Object::Serializable' => undef
	],
	props => [
		locales => PROP_RO | PROP_LIST,
		default => PROP_RO
	]
};

sub Invoke {
    my ($this,$action,$nextHandler) = @_;
    
    my @matches;
    
    my $best = [$this->default,0];
    
    if(my $header = $action->header('Accept-Language')) {
    	foreach my $part (split(/\s*,\s*/, $header)) {
    		my ($lang,$quality) = ($part =~ /([a-z]+(?:\-[a-z]+)*)(?:\s*;\s*q=(0\.[\d]+|1))?/i );
    		
    		$quality ||=1;
    		
    		foreach my $tag ($this->locales) {
    			if ( $tag =~ m/^$lang/i ) {
    				push @matches, [$tag,$quality];
    			}
    		}
    	}
    	
    	foreach my $match (@matches) {
    		if ($match->[1] > $best->[1]) {
    			$best = $match;
    		}
    	}
    	
    	
    }
    
    if (my $locale = $best->[0]) {
    	Resources->SetLocale($locale);
    }
    
    return $nextHandler->($action);
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Handler::LocaleHandler> - handles locale for the request

=head1 SYNOPSIS

=begin code xml

	<handlers type="ARRAY">
		<item type="IMPL::Web::Handler::LocationHandler"/>
	</handlers>

=end code xml

=cut