package Engine::Security::Auth;
use strict;
use Common;
our @ISA = qw(Object);
use Security;
use Security::Auth;
use Engine::Security::AccessDeniedException;

BEGIN {
    DeclareProperty ClientSecData => ACCESS_READ;
    DeclareProperty SecPackage => ACCESS_READ;
    DeclareProperty DataSource => ACCESS_READ;
    DeclareProperty DefaultUser => ACCESS_READ;
    DeclareProperty _AuthMod => ACCESS_NONE; # construct on demand
}

sub CTOR {
    my $this = shift;
    $this->SUPER::CTOR(@_);
    eval "require $this->{$ClientSecData};" or warn $@;
}

sub DoAuth {
    my ($this) = @_;
    
    my $data = $this->{$ClientSecData}->ReadSecData($this);
    my $SSID = $this->{$ClientSecData}->ReadSSID($this);
    
    my $AuthResult;
    
    if ($SSID) {
        $AuthResult = $this->AuthMod->AuthenticateSession($SSID,$data);
    } else {
        $AuthResult = new Security::AuthResult(State => Security::AUTH_NOAUTH);
    }
    
    if ($AuthResult->State == Security::AUTH_SUCCESS) {
        #warn "Session authenticated: ".$AuthResult->Session->User->Name;
    } else {
        #warn "Session is not authenticated: ".$AuthResult->State;
        if ($this->{$DefaultUser}) {
            $AuthResult = $this->AuthMod->AuthenticateUser($this->{$DefaultUser},undef);
        }
    }
    
    return $AuthResult;
}

sub SetAuthResult {
    my ($this,$AuthResult) = @_;

    if ($AuthResult and $AuthResult->State == Security::AUTH_SUCCESS) {
        $this->_CurrentSession($AuthResult->Session);
        $this->{$ClientSecData}->WriteSecData($AuthResult->ClientSecData,$this);
    } else {
        $this->_CurrentSession(undef);
        $this->{$ClientSecData}->WriteSecData(undef,$this);
    }
}

sub _CurrentSession {
    my ($this,$Session) = @_;
    
    if (@_ >= 2) {
        $this->AuthMod->DS->CloseSession(Security->CurrentSession) if Security->CurrentSession;

        $this->{$ClientSecData}->WriteSSID($Session ? $Session->SSID : undef);
        Security->CurrentSession($Session);
    } else {
        return Security->CurrentSession;
    }
}

sub AuthMod {
    my ($this) = @_;
    if (not $this->{$_AuthMod}) {
        if ($this->{$DataSource} and $this->{$SecPackage}) {
            eval qq {
                require $this->{$DataSource};
                require  $this->{$SecPackage};
            } or warn $@;
            $this->{$_AuthMod} = Security::Auth->new(
                DS => $this->{$DataSource},
                SecPackage => $this->{$SecPackage}
            );
        } else {
            #construct default
            $this->{$_AuthMod} = Security::Auth->construct;
        }
    }
    return $this->{$_AuthMod};
}

1;
