#!/usr/bin/perl -w
use strict;

package ObjectStore::CDBI::Users;
use Common;
use Digest::MD5 qw(md5_hex);
our @ISA = qw(Object);

our $Namespace;
our $DataModule;

our $Prefix = $Namespace ? $Namespace.'::' : '';

if ($DataModule) {
    $DataModule =~ s/::/\//g;
    $DataModule .= '.pm';
    require $DataModule;
}

BEGIN {
    DeclareProperty DSNamespace => ACCESS_NONE;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$DSNamespace} = $args{'DSNamespace'};
}

sub ClassName {
    return $_[0]->{$DSNamespace} ? $_[0]->{$DSNamespace}. $_[1] : $_[1];
}

sub FindUser {
    my ($this,$uname) = @_;
    
    my @Users = $this->ClassName('Principal')->search(Name => $uname);
    return shift @Users;
}

sub CreateUser {
    my ($this,$uname,$description,$active) = @_;
    
    if (my $user = $this->FindUser($uname)) {
        die new Exception("The user is already exists",$uname);
    } else {
        return $this->ClassName('Principal')->insert({Name => $uname, Description => $description, Active => $active});
    }
}

sub DeleteUser {
    my ($this,$objUser) = @_;
    
    $objUser->delete;
}

sub GetUserAuthData {
    my ($this,$objUser,$objSecPackage) = @_;
    
    my @Data = $this->ClassName('AuthData')->search(User => $objUser,Package => $objSecPackage->Name);
    return $Data[0];
}

sub SetUserAuthData {
    my ($this,$objUser,$objSecPackage,$objAuthData) = @_;
    
    if (my $AuthData = $this->GetUserAuthData($objUser,$objSecPackage)) {
        $AuthData->AuthData(objAuthData->SessionAuthData);
        $AuthData->update;
    } else {
        $this->ClassName('AuthData')->insert({ User => $objUser, Package => $objSecPackage->Name, AuthData => $objAuthData->SessionAuthData});
    }
}

sub CreateSession {
    my ($this,$SSID,$objUser,$objAuthData) = @_;
    
    my $session = $this->ClassName('Session')->insert({SSID => $SSID, User => $objUser, SecData => $objAuthData->SessionAuthData, LastUsage => DateTime->now() });
    $session->autoupdate(1);
    return $session;
}

sub CloseSession {
    my ($this,$objSession) = @_;
    
    $objSession->delete;
}

sub LoadSession {
    my ($this,$SSID) = @_;
    my @Data = $this->ClassName('Session')->search(SSID => $SSID);
    if ($Data[0]) {
        $Data[0]->autoupdate(1);
        return $Data[0];
    }
}

sub construct {
    return __PACKAGE__->new(DSNamespace => $Prefix);
}
