use strict;
package Schema::DB::Type;
use Common;
our @ISA=qw(Object);

BEGIN {
    DeclareProperty Name => ACCESS_READ;
    DeclareProperty MaxLength => ACCESS_READ;
    DeclareProperty Scale => ACCESS_READ;
    DeclareProperty Unsigned => ACCESS_READ;
    DeclareProperty Zerofill => ACCESS_READ;
    DeclareProperty Tag => ACCESS_READ;
}

sub CTOR {
    my $this = shift;
    $this->SUPER::CTOR(@_);
    
    $this->{$Scale} = 0 if not $this->{$Scale};
}

sub isEquals {
    my ($a,$b) = @_;
    
    if (defined $a and defined $b) {
        return $a == $b;
    } else {
        if (defined $a or defined $b) {
            return 0;
        } else {
            return 1;
        }
    }
}

sub isSame {
    my ($this,$other) = @_;
    
    return ($this->{$Name} eq $other->{$Name} and isEquals($this->{$MaxLength},$other->{$MaxLength}) and isEquals($this->{$Scale},$other->{$Scale}));
}

1;
