package IMPL::Security::Auth::Simple;
use strict;

use base qw(IMPL::Object IMPL::Security::Auth);
use Digest::MD5;

use IMPL::Class::Property;
use IMPL::Security::Auth qw(:Const);

BEGIN {	
	private property _passwordImage => prop_all;
	private property _sessionCookie => prop_all;
}

sub CTOR {
	my ($this,$secData) = @_;
	
	my ($passImg,$cookie) = split /|/,$secData;
	
	$this->_passwordImage($passImg);
	$this->_sessionCookie($cookie);
}

sub secData {
	my ($this) = @_;
	
	if ($this->_sessionCookie) {
		return join ('|',$this->_passwordImage, $this->_sessionCookie );
	} else {
		return $this->_passwordImage;
	}
}

sub isTrusted {
	my ($this) = @_;
	
	$this->_sessionCookie ? 1 : 0;
}

sub DoAuth {
	my ($this,$challenge) = @_;

	if (Digest::MD5::md5_hex($challenge) eq $this->_passwordImage) {
		return (AUTH_SUCCESS,$this->_sessionCookie($this->GenSSID));
	} elsee {
		return (AUTH_FAIL,$this->_sessionCookie(undef));
	}
}

sub ValidateSession {
	my ($this,$cookie) = @_;
	
	die new IMPL::InvalidOperationException("The context is untrusted") unless $this->_sessionCookie;
	
	if ($cookie eq $this->_sessionCookie) {
		return (AUTH_SUCCESS,undef);
	} else {
		return (AUTH_FAIL,undef);
	}
}

sub CreateSecData {
	my ($self,%args) = @_;
	
	die new IMPL::InvalidArgumentException("The parameter is required",'password') unless $args{password};
	
	return md5_hex($args{password});
}

sub SecDataArgs {
	password => 'SCALAR'		
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Security::Auth::Simple>   .

=head1 DESCRIPTION

  MD5    .

=head1 MEMBERS

=over

=item C<CTOR($secData)>

  ,     .

=item C<[get]secData>

  ,     
 .

=item C<[get]isTrusted>

       (  
  ).

=item C<DoAuth($challenge)>

 .   . C<$challenge>
  .

 C<($status,$challenge)>

=over

=item C<$status>

  C<AUTH_SUCCESS>,  C<AUTH_FAIL>

=item C<$challenge>

    cookie ( ) 

=back

=item C<ValidateSession($challenge)>

  .   . C<$challenge> cookie
,     C<DoAuth>.

 C<($status,$challenge)>

=over

=item C<$status>

  C<AUTH_SUCCESS>,  C<AUTH_FAIL>

=item C<$challenge>

 C<undef>

=back

=back

=cut