package IMPL::Security::Principal;
use strict;
use warnings;

use base qw(IMPL::Object IMPL::Object::Autofill);
use IMPL::Class::Property;

BEGIN {
    public property name => prop_get;
    public property description => prop_all;
}

my $nobody;

sub nobody {
    $nobody = $_[0]->new(name => 'nobody', description => '') unless $nobody;
    return $nobody;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Security::Principal>  

C<[Autofill]>

=head1 MEMBERS

=over

=item C<CTOR(%props)>

  .

=item C<[get] name>

  .

=item C<[get,set] description>

  .

=back

=cut
