package Schema::DB::Column;
use Common;
our @ISA = qw(Object);

BEGIN {
    DeclareProperty Name => ACCESS_READ;
    DeclareProperty Type => ACCESS_READ;
    DeclareProperty CanBeNull => ACCESS_READ;
    DeclareProperty DefaultValue => ACCESS_READ;
    DeclareProperty Tag => ACCESS_READ;
}

sub CTOR {
    my $this = shift;
    $this->SUPER::CTOR(@_);
    
    $this->{$Name} or die new Exception('a column name is required');
    $this->{$CanBeNull} = 0 if not exists $this->{$CanBeNull};
    UNIVERSAL::isa($this->{$Type},'Schema::DB::Type') or die new Exception('a type is required for the column',$this->{$Name});
}

sub isEqualsStr {
    my ($a,$b) = @_;
    
    if (defined $a and defined $b) {
        return $a eq $b;
    } else {
        if (defined $a or defined $b) {
            return 0;
        } else {
            return 1;
        }
    }
}

sub isEquals {
    my ($a,$b) = @_;
    
    if (defined $a and defined $b) {
        return $a == $b;
    } else {
        if (defined $a or defined $b) {
            return 0;
        } else {
            return 1;
        }
    }
}

sub isSame {
    my ($this,$other) = @_;
    
    return ($this->{$Name} eq $other->{$Name} and $this->{$CanBeNull} == $other->{$CanBeNull} and isEqualsStr($this->{$DefaultValue}, $other->{$DefaultValue}) and $this->{$Type}->isSame($other->{$Type}));
}

1; 
