package IMPL::Web::View::ObjectFactory;
use strict;

our $AUTOLOAD;

use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		OpException => '-IMPL::InvalidOperationException'
	},
	base =>[
	   'IMPL::Object::Factory' => '@_'
	]
};

use IMPL::Resources::Strings {
    MsgNoMethod => 'Method "%method%" isn\'t found in "%target%"'
};

sub AUTOLOAD {
	my $this = shift;
	my ($method) = ($AUTOLOAD =~ m/(\w+)$/);
	
	return if $method eq 'DESTROY';
	my $target = $this->factory; 
	if ( $target->can($method) ) {
	   	return $target->$method(@_);
	} else {
	   die OpException->new( MsgNoMethod( method => $method, target => $target ) );
	}
}

1;