package IMPL::ORM::Schema::Relation::HasOne;
use strict;
use warnings;

use parent qw(IMPL::ORM::Schema::Relation);
use IMPL::Class::Property;

BEGIN {
    public property target => prop_get | owner_set;
    public property name => prop_get | owner_set;
}

our %CTOR = (
    'IMPL::ORM::Schema::Relation' => sub { 'HasOne' }
);

sub CTOR {
    my ($this,$name,$target) = @_;
    $this->name($name) or die new IMPL::InvalidArgumentException('A name is required for this relation');
    $this->target($target) or die new IMPL::InvalidArgumentException('A target is required for this relation',$name);
}

sub canHaveChildren {
    0;
}


1;
