package IMPL::Config::ReferenceDescriptor;
use strict;

use IMPL::Exception();
use IMPL::declare {
	base => [
		'IMPL::Object'             => undef,
		'IMPL::Config::Descriptor' => undef
	],
	props => [
		reference => 'ro',
		services  => 'ro',
		lazy      => 'ro',
		optional  => 'ro',
		default   => 'ro',
		_name     => 'rw'
	]
};

sub CTOR {
	my ( $this, $ref, %opts ) = @_;

	$this->reference($ref)
	  or die IMPL::InvalidArgumentException->new('ref');

	$this->_name( 'ref ' . $ref );
}

sub Activate {
	my ( $this, $context ) = @_;

	$this->EnterScope( $this->_name, $this->services );

	my $ref = $this->reference;
	my %opts;
	$opts{default} = $this->default
	  if $this->optional;

	if ( $this->lazy ) {
		my $clone = $context->Clone();
		return sub {
			$clone->Resolve( $ref, %opts );
		};
	}
	else {
		return $context->Resolve( $ref, %opts );
	}

	$this->LeaveScope();
}

1;
