package IMPL::Test::Result;
use strict;
use warnings;

use IMPL::Const qw(:prop);
use IMPL::declare {
	base => [
		'IMPL::Object' => undef,
		'IMPL::Object::Serializable' => '@_'
	],
	props => [
		name => PROP_RW,
		state => PROP_RW,
		exception => PROP_RW,
		timeExclusive => PROP_RW,
		timeInclusive => PROP_RW
	]
};

__PACKAGE__->PassThroughArgs;

use constant {
    SUCCESS => 0,
    FAIL => 1,
    ERROR => 2
};

sub CTOR {
    my $this = shift;
    
    my $fields = @_ == 1 ? $_[0] : {@_};
    
    $fields->{timeExclusive} ||= 0;
    $fields->{timeInclusive} ||= 0;
    
    while (my ($k,$v) = each %$fields) {
    	$this->$k($v);
    }
}


1;
