package IMPL::Config::ActivationContext;

use IMPL::Const qw(:prop);
use IMPL::Exception();
use IMPL::declare {
	require => {
		PropertyBag => 'IMPL::Config::ServicesBag'
	},
	base => {
		'IMPL::Object' => '@_'
	},
	props => {
		container => PROP_RW,
		_services => PROP_RW,
		_cache    => PROP_RW,
		_stack    => PROP_RW
	}
};

sub CTOR {
	my ( $this, $container ) = @_;

	$this->container($container)
	  or die IMPL::InvalidArgumentException('container');
}

sub EnterScope {
	my ( $this, $name, $services ) = @_;

	my $info = { name => $name };

	if ($services) {
		$info->{services} = $this->_services;

		$this->_services( $services );
	}

	$this->_stack->Push($info);
}

sub LeaveScope {
	my ($this) = @_;

	my $info = $this->_stack->Pop()
	  or die IMPL::InvalidOperationException();

	if ( $info->{services} ) $this->_services( $info->{services} );
}

sub Resolve {
	my ($this, $role, %opts) = @_;
}

sub Clone {
	my ($this) = @_;
}

1;
__END__

=pod

=head1 NAME

C<IMPL::Config::ActivationContext> - an activation context for the service

=head1 SYNOPSIS

For the internal use only

=head1 MEMBERS

=head2 METHODS

=head3 GetService($serviceId)

=cut
