package IMPL::Web::Application::RestCustomResource;
use strict;

use IMPL::lang qw(:declare :constants);
use IMPL::declare {
	require => {
		Exception => "IMPL::Exception",
		ArgumentException => '-IMPL::InvalidArgumentException',
		ForbiddenException => 'IMPL::Web::ForbiddenException',
		NotFoundException => 'IMPL::Web::NotFoundException'
	},
	base => {
		'IMPL::Web::Application::RestBaseResource' => '@_'
	}
};

BEGIN {
	public property get => PROP_GET | PROP_OWNERSET;
	public property put => PROP_GET | PROP_OWNERSET;
	public property post => PROP_GET | PROP_OWNERSET;
	public property delete => PROP_GET | PROP_OWNERSET;
}

sub FetchChildResource {
	my ($this,$id,$action) = @_;
	
	die NotFoundException->new() if $this->final;
	
	return $this->contract->Transform( $this->GetImpl($action), { parent => $this, id => $id } )->FetchChildResource($id,$action);
}

sub GetImpl {
	my ($this,$action) = @_;
	
	my $method = $this->get or die ForbiddenException->new();
	return $this->InvokeMember($method,$action);
}

sub PutImpl {
	my ($this,$action) = @_;
	my $method = $this->put or die ForbiddenException->new();
    return $this->InvokeMember($method,$action);
}

sub PostImpl {
	my ($this,$action) = @_;
	my $method = $this->post or die ForbiddenException->new();
    return $this->InvokeMember($method,$action);
}

sub DeleteImpl {
	my ($this,$action) = @_;
	my $method = $this->delete or die ForbiddenException->new();
    return $this->InvokeMember($method,$action);
}

sub InvokeMember {
	my ($this,$method,$action) = @_;
	
	return $this->$method($action);
}

1;