package IMPL::Web::View::TTDocument;
use strict;

use Scalar::Util qw(weaken);
use IMPL::Const qw(:prop);
use IMPL::lang qw(:hash is);
use Carp qw(carp);
use mro;
use IMPL::Exception();
use IMPL::declare {
    require => {
    	TTRegistry => 'IMPL::Web::View::TTRegistry',
        TTFactory => 'IMPL::Web::View::TTFactory',
        TTControl =>  'IMPL::Web::View::TTControl',
        Loader => 'IMPL::Code::Loader',
        OpException => '-IMPL::InvalidOperationException'
    },
    base => [
        'IMPL::Web::View::TTControl' => sub {
            my ($template,$ctx,$vars) = @_;
            $ctx ||= Template::Context->new();
            return $template, $ctx, $vars;  # context
        }
    ]
};

sub CTOR {
    my ($this,$template,$ctx) = @_;
    
    $this->layout( $template->layout ) unless $this->layout;
    $this->title( $template->title ) unless $this->title;
}

sub Render {
    my ($this,$args) = @_;
    
    my $ctx = $this->context;

    $args ||= {};
    $args->{document} = $this;
    $args->{render} = sub {
    	my ($model,$factory) = @_;
    	
    	$factory = $ctx->require($factory) unless is($factory,TTFactory);
    	
    	return $factory->new({document => $this, model => $model})->Render();
    };
    
    
    if ($this->layout) {
    	my $layout = $this->registry->Require($this->layout)->new();
    	
    	my $next = $this->next::can();
    	
    	return $layout->Render({
            content => sub { $this->$next($args) },
            template => $this->template,
            document => $this
        });
    } else {
        return $this->next::method($args);
    }
}

sub GetTemplate {
    my ($this,$name) = @_;
    
    $this->template->blocks->{$name};
}

sub DTOR {
	my $this = shift;
	
	$this->registry->Dispose() if $this->registry;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::View::TTDocument> - документ для построения HTML страницы на основе шаблонов TT.

=head1 SYNOPSIS

=begin code


=end code

=head1 DESCRIPTION

Позволяет строить представления при помощи Template Toolkit, при этом расширяет
шаблоны до элементов управления, чтобы была возмлжность реализации функционала
средствами C<Perl>.

Структура представления.

=begin text

 + view 
 |- document.tt
 |-+items
 | |- title.tt
 | |- item.tt
 |  
 |-+layouts
   |-  
  
=end text

=begin text



=end text

=begin plantuml

@startuml

object "doc: TTDocument"  as doc
object "docCtx: TTContext" as docctx
object "factory: TTFactory" as factory 
object "registry: TTRegistry" as registry
object "control: TTControl" as ctl
object "ctlCtx: TTContext" as ctlctx

doc -up-> docctx
registry --> "0..*" factory
factory .> doc: <<creates>>
factory .up.> ctl: <<creates>>
docctx -up-> registry
ctl -> ctlctx 
ctlctx --> registry 
ctlctx --> doc

@enduml

=end plantuml

=cut