package Test::Resources::Strings;
use strict;

use IMPL::Test qw(assert test);
use IMPL::declare {
	require => {
		Resources => 'IMPL::Resources'
	},
	base => [
		'IMPL::Test::Unit' => '@_'
	]
};

use IMPL::Resources::Strings {
	HelloMessage => "Hello, %name%!",
	TitleLabel => "Hellow world!"
};

test TestDefaultMessage => sub {
	assert( HelloMessage( name => 'John') eq "Hello, John!" );
};

test TestPlainResourceFile => sub{
	Resources->InvokeInLocale(en_INF1 => sub {
		assert( HelloMessage( name => 'Peter' ) eq "Hi, Peter!" );
		assert( TitleLabel, "Hellow world!");
	});
};

test TestPerlResourceFile => sub {
	Resources->InvokeInLocale(en_INF2 => sub {
		assert( HelloMessage( name => 'Sam' ) eq "I know you, Sam!");
	});
};

1;