#!/usr/bin/perl
use strict;
use Carp;
use Time::HiRes qw(gettimeofday tv_interval);
use Scalar::Util qw(blessed refaddr);
use YAML::XS qw(Dump);

my $t = [gettimeofday];

use IMPL::require {
	Container => 'IMPL::Config::Container',
	Service => 'IMPL::Config::ServiceDescriptor',
	Reference => 'IMPL::Config::ReferenceDescriptor',
	Value => 'IMPL::Config::ValueDescriptor'
};

my $c1 = Container->new();

$c1->Register('db', Service->new(
    type => 'Foo::Data',
    norequire => 1,
    activation => 'container'
) );

$c1->Register(['sec', 'ldap'], Reference->new('db') );

$c1->Register('mixed', Value->new([
    Reference->new('db'),
    Reference->new('sec'),
    Reference->new('ldap')
]));

my $c2 = Container->new($c1);

my $data = [ $c1->Resolve('mixed')] ;

print "Activated: ",tv_interval($t,[gettimeofday]),"\n";

print Dump($data);


package Foo::Data;
use IMPL::declare {
	base => [
	   'IMPL::Object' => undef
	]
};

1;
