use strict;
package Deployment::Batch::Temp;
use parent qw(Deployment::Batch::Generic);
use Common;
use File::Temp;


BEGIN {
    DeclareProperty TmpObj => ACCESS_READ;
    DeclareProperty Ref => ACCESS_NONE;
    DeclareProperty TmpObjType => ACCESS_NONE;
}

sub CTOR {
    my ($this,$type,$ref) = @_;

    die "A reference to the temp object can be obtained only in the immediate mode" if $ref and not $this->Context->{Immediate};

    $this->{$TmpObjType} = $type or die "The type of a temporary object should be specified";
    $this->{$Ref} = $ref;
}

sub Run {
    my ($this) = @_;

    if ($this->{$TmpObjType} eq 'File') {
        $this->{$TmpObj} = File::Temp->new;
        if ($this->{$Ref}) {
            ${$this->{$Ref}} = $this->{$TmpObj};
        } else {
            $this->Context('tmpfile') = $this->{$TmpObj}->filename;
        }
    } elsif ($this->{$TmpObjType} eq 'Dir') {
        $this->{$TmpObj} = File::Temp->newdir;
        if ($this->{$Ref}) {
            ${$this->{$Ref}} = $this->{$TmpObj};
        } else {
            $this->Context('tmpdir') = $this->{$TmpObj}->dirname;
        }
    } else {
        die "Don't know how to create a temporary $this->{$TmpObjType}";
    }
}

sub DESTORY {
    my ($this) = @_;

    undef $this->{$TmpObj};
}


1;
