use strict;
package IMPL::SQL::Schema::Column;
use parent qw(IMPL::Object IMPL::Object::Autofill);

use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

BEGIN {
    public _direct property name => prop_get;
    public _direct property type => prop_get;
    public _direct property isNullable => prop_get;
    public _direct property defaultValue => prop_get;
    public _direct property tag => prop_get;
}

__PACKAGE__->PassThroughArgs;

sub CTOR {
    my $this = shift;
    
    $this->{$name} or die new IMPL::InvalidArgumentException('a column name is required');
    $this->{$isNullable} = 0 if not exists $this->{$isNullable};
    UNIVERSAL::isa($this->{$type},'IMPL::SQL::Schema::Type') or die new IMPL::InvalidArgumentException('a type is required for the column',$this->{$name});
}

sub isEqualsStr {
    my ($a,$b) = @_;
    
    if (defined $a and defined $b) {
        return $a eq $b;
    } else {
        if (defined $a or defined $b) {
            return 0;
        } else {
            return 1;
        }
    }
}

sub isEquals {
    my ($a,$b) = @_;
    
    if (defined $a and defined $b) {
        return $a == $b;
    } else {
        if (defined $a or defined $b) {
            return 0;
        } else {
            return 1;
        }
    }
}

sub isSame {
    my ($this,$other) = @_;
    
    return ($this->{$name} eq $other->{$name} and $this->{$isNullable} == $other->{$isNullable} and isEqualsStr($this->{$defaultValue}, $other->{$defaultValue}) and $this->{$type}->isSame($other->{$type}));
}

1; 
