use strict;
package IMPL::SQL::Schema::Constraint;
use parent qw(IMPL::Object IMPL::Object::Disposable);

use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

BEGIN {
    public _direct property name => prop_get;
    public _direct property table => prop_get;
    public _direct property columns => prop_get;
}

sub CTOR {
    my ($this,%args) = @_;
    die new IMPL::InvalidArgumentException("The table argument must be an instance of a table object") if not UNIVERSAL::isa($args{'table'},'IMPL::SQL::Schema::Table');
    $this->{$name} = $args{'name'};
    $this->{$table} = $args{'table'};
    $this->{$columns} = [map { ResolveColumn($this->table,$_) } @{$args{'columns'}}];
}

sub ResolveColumn {
    my ($Table,$Column) = @_;
    
    my $cn = UNIVERSAL::isa($Column,'IMPL::SQL::Schema::Column') ? $Column->name : $Column;
    
    my $resolved = $Table->Column($cn);
    die new IMPL::InvalidOperationException("The column is not found in the table", $cn, $Table->name) if not $resolved;
    return $resolved;
}

sub HasColumn {
    my ($this,@Columns) = @_;
    
    my %Columns = map { $_, 1} @Columns;
    
    return scalar(grep { $Columns{$_->name} } @{$this->columns}) == scalar(@Columns);
}

sub uniqName {
    my ($this) = @_;
    return $this->{$table}->name.'_'.$this->{$name};
}

sub Dispose {
    my ($this) = @_;
    
    delete @$this{$table,$columns};
    $this->SUPER::Dispose;
}
1;
