package IMPL::SQL::Schema::Traits::Diff;
use strict;
use warnings;
use IMPL::lang;

use IMPL::SQL::Schema();
use IMPL::SQL::Schema::Traits();

use constant {
	schema_t => typeof IMPL::SQL::Schema # defining a constant is a good style to enable compile checks
};

sub Diff {
	my ($self,$src,$dst) = @_;
	
	die new IMPL::InvalidArgumentException( src => "A valid source schema is required") unless is($src,schema_t);
	die new IMPL::InvalidArgumentException( dst => "A valid desctination schema is requried" ) unless is($src,schema_t);
	
	my %dstTables = map { $_->name, $_ } $dst->GetTables;
	
	my @operations;
	
	foreach my $srcTable ( $src->GetTables) {
		my $dstTable = delete $dstTables{$srcTable->name};
		
		if (not $dstTable) {
			push @operations, new IMPL::SQL::Schema::Traits::DropTable()
		} else {
			
		}
	
	}  
}

1;