package IMPL::Web::Application::OperationContract;
use strict;

use IMPL::declare {
	base => [
	   'IMPL::Object' => undef,
	   'IMPL::Object::Autofill' => '@_'
	],
	props => [
	   binding => PROP_ALL,
	   response => PROP_ALL
	]
};

sub Invoke {
	my ($this, $resource, $httpAction) = @_;
	
	if ($this->)
	
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Application::OperationContract> - Описание операции над
веб-ресурсом.

=head1 SYNOPSIS

=begin code

use IMPL::require {
	'OperationContract' => 'IMPL::Web::Application::OperationContract',
	'RedirectResponse' => 'IMPL::Web::Application::RedirectResponse'
};

my $operation = OperationContract->new(
    bind => sub {
    	my ($resource,$model,$itemName) = @_;
    	
    	return $model->findItem($itemName);
    },
    response => RedirectResponse->new(
        locator => $relativeLocator
    ) 
);

my $response = $operation->InvokeOperation($resource);

=end code

=head1 DESCRIPTION

Связывает методы предметной области с операциями над ресурсами. Для связи с
моделью используется функция, которой будут переданы параметры:

=over

=item C<$reousrce> Ресурс для которого выполняется операция

=item C<$model> Объект модели данных, связанный с данным ресурсом, тоже, что
и C<<>$resource->model>> только для краткости

=item C<$action> Контекст текущего C<HTTP> запроса.

=back

Результат выполнения будет передан дополнительному обработчику C<response>,
который выполнит необходимое преобразование.

=head1 MEMBERS

=cut