package IMPL::Class::MemberInfo;
use strict;
use IMPL::_core::version;
use parent qw(IMPL::Object::Accessor);

require IMPL::Exception;

use constant {
    MOD_PUBLIC => 1,
    MOD_PROTECTED => 2,
    MOD_PRIVATE => 3
};

#TODO remove Virtual
__PACKAGE__->mk_accessors(
    qw(
        Name
        Access
        Virtual
        Class
        Frozen
        Implementor
        Attributes
    )
);
__PACKAGE__->PassThroughArgs;

sub CTOR {
    my $this = shift;
    
    die new IMPL::Exception('The name is required for the member') unless $this->Name;
    die new IMPL::Exception('The class is required for the member') unless $this->Class;
    
    $this->Attributes({}) unless defined $this->Attributes;
    $this->Frozen(0);
    $this->Virtual(0) unless defined $this->Virtual;
    $this->Access(3) unless $this->Access;
}

sub Implement {
    my ($this) = @_;
    $this->Implementor->Make($this);
    $this->Frozen(1);
    $this->Class->set_meta($this);
    return;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Class::MemberInfo> - информация о члене класса.

=head1 DESCRIPTION

Данный класс является базовым для таких классов как C<IMPL::Class::PropertyInfo>, C<IMPL::Class::MethodInfo> и 
предназначен для хренения метаданных.

Данный класс наследуется от C<IMPL::Object::Accessor> и не содержит в себе метаданных о своих членах.

=head1 MEMBERS

=over

=item C<[get,set] Name>

Имя члена.

=item C<[get,set] Access>

Default public.

Атрибут доступа ( public | private | protected )

=item C<[get,set] Virtual>

Default false.

Флаг виртуальности.

=item C<[get,set] Class>

Класс владелец
        
=item C<[get,set] Frozen>

Флаг невозможности внесения изменений

=item C<[get,set] Attributes>

Дополнительные атрибуты

=item C<Implement()>

Устанавливает C<Frozen> в C<1>, добавляет в метаданные класса.

При реализации собственного субкласса, данный метод может быть переопределен для
реализации дополнительной обработки (например, создание методов доступа для свойств).

=back

=cut
