package IMPL::Code::Loader;
use strict;
use warnings;

use IMPL::lang qw(:declare :constants);

use IMPL::declare {
	require => {
		Exception => 'IMPL::Exception',
		ArgumentException => '-IMPL::InvalidArgumentException' 
	},
	base => {
		'IMPL::Object' => undef,
		'IMPL::Object::Autofill' => '@_'
	}
};

my $default;
sub default {
	$default ||= new IMPL::Code::Loader;
}

my $safe;
sub safe {
	$safe ||= new IMPL::Code::Loader(verifyNames => 1);
}

BEGIN {
	public property verifyNames => PROP_GET | PROP_OWNERSET;
	public property prefix => PROP_GET | PROP_OWNERSET;
}


sub Require {
    my ($this,$package) = @_;
    
    if ($this->verifyNames) {
    	$package =~ m/^([a-zA-Z_0-9]+(?:::[a-zA-Z_0-9]+)*)$/ or die ArgumentException->new("package") ;
    }
    
    $package = $this->prefix . $package if $this->prefix;
    
    my $file = join('/', split(/::/,$package)) . ".pm";
    
    require $file;
}

1;

