package IMPL::Web::View::TTRegistry;
use strict;
use mro;

use IMPL::Const qw(:prop);
use IMPL::declare {
    require => {
        TTFactory => 'IMPL::Web::View::TTFactory'        
    },
    base => [
        'IMPL::Object' => undef,
        'IMPL::Object::Disposable' => undef
    ],
    props => [
        loader => PROP_RW,
        context => PROP_RW,
        _cache => PROP_RW,
    ]
};

sub CTOR {
	my ($this,$loader,$context) = @_;
	
	$this->loader($loader);
	$this->context($context);
	$this->_cache({});
}

sub Require {
    my ($this,$name) = @_;
    
    if(my $factory = $this->_cache->{$name}) {
        return $factory;
    } else {
        my $template = $this->loader->template($name)
            or die AppException->new("Failed to load a template $name");
         
        $factory = TTFactory->new(
            $template,
            $this->context,
            $name,
            $this
        );
        
        $this->_cache->{$name} = $factory;
        return $factory;
    }
}

sub Dispose {
	my ($this) = @_;
	
	$this->_cache(undef);
	$this->context(undef);
	$this->loader(undef);
	
	$this->next::method();
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::View::Registry> - реестр шаблонов документа.

=head1 DESCRIPTION

Используется для реализации функции C<require> внутри шаблонов.



=cut
