package IMPL::Security::Role;

use base qw(IMPL::Object);

use IMPL::Class::Property;

BEGIN {
	public property roleName => prop_get | owner_set;
	public property parentRoles => prop_get | owner_set | prop_list;
}

sub CTOR {
	my ($this,$name,$parentRoles) = @_;
	
	$this->roleName($name) if $name;
	$this->parentRoles($parentRoles) if $parentRoles;
}

sub Satisfy {
	my ($this,@roles) = @_;	
	
	return 1 unless $this->_FilterRoles( @roles );
	return 0;
}

sub _FilterRoles {
	my ($this,@roles) = @_;
	
	@roles = grep not (ref $_ ? $this == $_ : $this->roleName eq $_), @roles;
	
	@roles = $_->_FilterRoles(@roles) or return foreach $this->parentRoles ;
	
	return @roles;
}


1;

__END__

=pod

=head1 NAME

C<IMPL::Security::Role> 

=head1 DESCRIPTION

     .
         .

=head1 MEMBERS

=over

=item C<[get] roleName>

 ,  

=item C<[get,list] parentRoles>

  

=item C<Satisfy(@roles_list)>

       @roles_list.
    ,    .
 0   , 1    

=back

=cut