package Schema::Form::Field;
use strict;
use Common;
use base qw(Schema::Form::Item);

BEGIN {
    DeclareProperty Format => ACCESS_READ;
}

sub CTOR {
    my ($this,%args) = @_;
    
    $args{'Format'} or die new Exception('A format is required for a field');
    
    $args{'Attributes'} = { %{$args{Format}->Attributes},%{$args{Attributes} || {} } };
    
    $this->SUPER::CTOR(@args{qw(Name isMulti Filters Attributes)});
    $this->{$Format} = $args{'Format'};
}

=pod
       
=cut
sub Filters {
    my ($this) = @_;
    
    my @filters = $this->{$Format}->Filters;
    push @filters,$this->SUPER::Filters;
    
    return @filters;
}

1;
