package IMPL::Web::Exception;
use strict;
use warnings;

use IMPL::Const qw(:prop);
use IMPL::declare {
	base => [
	   'IMPL::Exception' => '@_'
	],
	props => [
	   headers => PROP_ALL
	]
};

sub status {
	"500 Internal error";
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Exception> - Базовый класс для всех web-исключений, для ошибок вызванных
по вине клиента.

=head1 SYNOPSIS

Вызов исключения

=begin code

use IMPL::require {
	WebException => 'IMPL::Web::WebException'
};

sub MyWebHandler {
	# ...
	
	die WebException->new("something is wrong"); 
	
	# ...	
}

=end code

=head1 MEMBERS

=head2 C<status()>

Возвращает C<HTTP> код ошибки. Каждый класс иключений должен переопределить данный метод.

=head2 C<[get,set]headers>

Ссылка на хеш с параметрами заголовка.

=cut