package Test::SQL::Diff;
use strict;
use warnings;

use IMPL::declare {
    require => {
        MySQLProcessor => 'IMPL::SQL::Schema::MySQL::Processor',
        SQLSchema => 'IMPL::SQL::Schema',
        SQLDiff => 'IMPL::SQL::Schema::Diff'
    },
    base => [
        'IMPL::Test::Unit' => '@_'
    ]    
};

use IMPL::Test qw(test failed assert);
use IMPL::SQL::Types qw(Integer Varchar Text);
use Data::Dumper;


test diff => sub {
    my $schemaSrc = SQLSchema->new(name => 'simple', version => 1 );
    
    my $schemaDst = SQLSchema->new(name => 'simple', version => 2 );
    
    my $users = $schemaDst->AddTable({
        name => 'User',
        columns => [
            { name => 'id', type => Integer, tag => {auto_increment => 1} },
            { name => 'login', type => Varchar(255) },
            { name => 'description', type => Text, isNullable => 1 }
        ]
    });
    
    $users->SetPrimaryKey('id');
    $users->AddConstraint( unique => { name => 'unique_login', columns => ['login'] } );
    
    my $profile = $schemaDst->AddTable({
        name => 'Profile',
        columns => [
            { name => 'id', type => Integer, tag => {auto_increment => 1} },
            { name => 'uid', type => Integer },
            { name => 'data', type => Text }
        ]
    });
    
    $profile->SetPrimaryKey('id');
    $profile->LinkTo($users, 'uid');
    
    my $diff = SQLDiff->Diff($schemaSrc,$schemaDst);
    
    my $processor = MySQLProcessor->new($schemaSrc);
    $processor->ProcessBatch($diff);
    
    warn Dumper($diff);
    warn Dumper($processor->sqlBatch);
    
    $schemaSrc->Dispose;
    $schemaDst->Dispose;
    
};


1;
