package IMPL::Web::Application::CustomResource;
use strict;

use IMPL::lang qw(:constants);

use IMPL::declare {
    require => {
        CustomResourceContract => 'IMPL::Web::Application::CustomResourceContract'        
    },
    base => [
        'IMPL::Web::Application::Resource' => '@_'
    ]
};

__PACKAGE__->static_accessor(contractFactory => CustomResourceContract );
__PACKAGE__->static_accessor_own(_contractInstance => undef);

sub contractInstance {
    my ($self) = @_;
    
    $self = ref $self || $self;
    $self->_contractInstance ? $self->_contractInstance : $self->InitContract();
}

sub InitContract {
    my ($self) = @_;
    
    $self->_contractInstance( $self->contractFactory->new(resourceFactory => $self ) ); 
}

sub GetChildResources {
    
}


1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Application::CustomResource> - базовый класс для ресурсов,
реальзуемых в коде.

=head1 SYNOPSIS

=begin code

package MyApp::Web::Resources::ProfileResource;
use IMPL::declare {
    base => [
        'IMPL::Web::Application::CustomResource' => '@_'
    ]
}

sub HttpGet {
    my ($this) = @_;
    return $this->model;
}

sub HttpPut {
    my ($this,$action) = @_;
    
    my $form = MyApp::Web::Schema::UpdateUser->new();
    
    $this->model->update( $form->Bind($action) );
}

=end code

=head1 MEMBERS

=head2 C<[static]contractFactory>

Фабрика, используемая для получения контракта ресурса. По умолчанию
C<IMPL::Web::Application::CustomResourceContract>.

=head2 C<[static]contractInstance>

Экземпляр контракта для ресурса. Создается при первом обращении при помощи
метода C<InitContract()>.

=head2 C<[static]InitContract()>

Создает новый экземпляр контракта, используя фабрику из свойства C<contractFactory>.

=head2 C<[static]GetChildResources()>

Статический метод, который должны переопределять новые классы ресурсов, у
которых есть дочерние ресурсы.

=begin code

package MyApp::Web::MyResource

sub GetChildResources {
    my $self = shift;
    return
        $self->SUPER::GetChildResources(),
        {
            
        }
        {
            
        };
}

=end code


=cut