package IMPL::DOM::Schema::ValidationError;
use strict;
use warnings;

use overload
    '""' => \&toString,
    'fallback' => 1;

use base qw(IMPL::Object);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;
use IMPL::Resources::Format qw(FormatMessage);

BEGIN {
    public _direct property Node => prop_get; # target document node (if exists)
    public _direct property Schema => prop_get; # a schema for the target node (if exists) 
    public _direct property Source => prop_get; # a schema which triggered this error (can be equal to the Schema)
    public _direct property Parent => prop_get; 
    public _direct property Message => prop_get; # displayable message
}

sub CTOR {
    my ($this,%args) = @_;
    
    $this->{$Node} = $args{Node};
    $this->{$Schema} = $args{Schema} if $args{Schema};
    $this->{$Source} = $args{Source} if $args{Source};
    if ($args{Parent}) {
    	$this->{$Parent} = $args{Parent};
    } elsif ($args{Node}) {
    	$this->{$Parent} = $args{Node}->parentNode;
    } else {
    	die new IMPL::InvalidArgumentException("A 'Parent' or a 'Node' parameter is required");
    }
    $this->{$Message} = FormatMessage(delete $args{Message}, \%args) if $args{Message};
}

sub toString {
	(my $this) = @_;
	return $this->Message;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::DOM::Schema::ValidationError> -    .

=head1 DESCRIPTION

         
C<IMPL::DOM::Schema::ValidationError>,      
 .

       ,  
     .

=head1 MEMBERS

=over
=item C<[get] Node>


      .      , 
,         .

    C<undef>. 

=item C<[get] Parent>

     .   ,  C<Node>
 , ,         
,      .

       .

=item C<[get] Schema>

  C<Node>       C<Node>  .

=item C<[get] Source>

,      .   
 ,        ,  
  .

    C<IMPL::DOM::Schema::Node>    
, , C<IMPL::DOM::Schema::ComplexType>,   C<Source> 
   C<IMPL::DOM::Schema::Node>.

=item C<[get] Message>

    .

=item C<toString()>

   ,    C<Message>

=back

=head1 REMARKS

=begin code

my $doc = IMPL::DOM::XMLReader->LoadDocument('data.xml');
my $schema = IMPL::DOM::Schema->LoadSchema('schema.xml');

my @errors = $schema->Validate($doc);

my $node = $doc->selectSingleNode('user','name');

#       
my @nodeErrors = grep { ($_->Node || $_->Parent) == $node } @errors;  

=end code

=cut
