use strict;
use warnings;

package IMPL::Resources::Strings::Storage;
package IMPL::Resources::Strings;
use File::Spec;

our $Locale ||= 'default';
our $Base ||='locale';
our $Encoding ||= 'utf-8';
our @Locations;

@Locations = ('.') unless @Locations;

sub import {
    my ($self,$refStrings,%options) = @_;
    
    my ($class,$pathModule) = caller;
    
    my ($vol,$dir,$file) = File::Spec->splitpath($pathModule);
    my $baseDir = File::Spec->catpath($vol,$dir,'');
    
    my @pathClass = split /::/,$class;
    my $fileClass = pop @pathClass;
    
    my @ways = map {
        my @path = ($_);
        push @path,$Base;
        push @path,$Locale;
        
        File::Spec->catfile(@path,@pathClass,$fileClass);
    } @Locations;
    
    push @ways, File::Spec->catfile($baseDir,'locale',$Locale,$fileClass);
    
    
    
    my $stringsStorage = findResource($class,@ways);
    
}

sub findResource {
    my ($class,$refWays) = @_;
    
    
}



sub parseResource {
    my ($fname) = @_;
    
    open my $hRes, "<:encoding($Encoding)", findFile($fname) or die "Failed to open file $fname: $!";
    
    my %Map;
    my $line = 1;
    while (<$hRes>) {
        chomp;
        $line ++ and next if /^\s*$/;
        
        if (/^(\w+)\s*=\s*(.*)$/) {
            $Map{$1} = $2;
        } else {
            die "Invalid resource format in $fname at $line";
        }
        $line ++;
    }
    
    return \%Map;
}

package IMPL::Resources::Strings::Storage;
use base qw(IMPL::Object);

sub get {
    my ($this,$msg_name) = @_;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Resources::Strings> -  

=head1 SYNOPSIS

=begin code

package Foo;

use IMPL::Resources::Strings {
    msg_say_hello => "Hello, %name!",
    msg_module_name => "Simple Foo class"
}, auto => 1, locale => 'en-us';

sub InviteUser {
    my ($this,$uname) = @_;
    
    print msg_say_hello(name => $uname);
    
}

=end code

=head1 DESCRIPTION

    ,   
 .

      :

    C<@Locations>     
C<$Base/$Locale/$ModName>,  C<$Base>, C<$Locale> -  
 C<IMPL::Resourses::Strings>,   C<$ModName> 
  'C<::>'      'C</>'.

    ,     , 
  ,     C<locale/$Locale/$ShortModName>,
 C<$ShortModeName> -    'C<::>'    .

   ,   ,   
   .

=head1 FORMAT

=begin code text

msg_name = any text with named %params%
msg_hello = hello, %name%!!!
msg_resolve = this is a value of the property: %user.age%

msg_short_err = %error.Message%
msg_full_err = %error% 

=end code text 

=cut
