package IMPL::SQL::Types;
use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(&Integer &Varchar &Float &Real &Text &Binary &DateTime);

require IMPL::SQL::Schema::Type;

sub Integer() {
    return IMPL::SQL::Schema::Type->new(Name => 'INTEGER');
}

sub Varchar($) {
    return IMPL::SQL::Schema::Type->new(Name => 'VARCHAR', Length => shift);
}

sub Float($) {
    return IMPL::SQL::Schema::Type->new(Name => 'FLOAT', Scale => shift);
}

sub Real() {
    return IMPL::SQL::Schema::Type->new(Name => 'REAL');
}

sub Text() {
    return IMPL::SQL::Schema::Type->new(Name => 'TEXT');
}

sub Binary() {
    return IMPL::SQL::Schema::Type->new(Name => 'BINARY');
}

sub DateTime() {
    return IMPL::SQL::Schema::Type->new(Name => 'DATETIME');
}

1;
