package IMPL::DOM::Navigator::SimpleBuilder;
use strict;
use warnings;

use parent qw(IMPL::DOM::Navigator);

use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

require IMPL::DOM::Navigator::SchemaNavigator;
use IMPL::DOM::Document;

BEGIN {
    public _direct property Document => prop_get | owner_set;
}

our %CTOR = (
    'IMPL::DOM::Navigator' => sub { IMPL::DOM::Document::Empty; }
);

sub NavigateCreate {
    my ($this,$nodeName,%props) = @_;
    
    my $node;
    if (! $this->{$Document}) {
        $node = $this->{$Document} = IMPL::DOM::Document->new(nodeName => $nodeName,%props);
        $this->_initNavigator($node);
    } else {
        die new IMPL::InvalidOperationException('Can\t create a second top level element') unless $this->Current;
        $node = $this->{$Document}->Create($nodeName,'IMPL::DOM::Node',\%props);
        $this->Current->appendChild($node);
        $this->internalNavigateNodeSet($node);
    }
    return $node;
}

sub inflateValue {
    $_[1];
}

1;
