package IMPL::Object;
use strict;

use base qw(IMPL::Object::Abstract);

sub surrogate {
    bless {}, ref $_[0] || $_[0];
}

sub new {
    my $class = shift;
    my $self = bless {}, ref($class) || $class;    
    $self->callCTOR(@_);
  
    $self;
}

sub _PropertyImplementor {
    'IMPL::Class::Property::Direct'
}

=pod
=h1 SYNOPSIS

package Foo;
use base qw(IMPL::Object);

sub CTOR {
    my ($this,$arg) = @_;
    print "Foo: $arg\n";
}

package Bar;
use base qw(IMPL::Object);

sub CTOR {
    my ($this,$arg) = @_;
    print "Bar: $arg\n";
}

package Baz;
use base qw(Foo Bar);

our %CTOR = (
    Foo => sub { my %args = @_; $args{Mazzi}; },
    Bar => sub { my %args = @_; $args{Fugi}; }
);

package Composite;
use base qw(Baz Foo Bar);

our %CTOR = (
    Foo => undef,
    Bar => undef
);

sub CTOR {
    my ($this,%args) = @_;
    
    print "Composite: $args{Text}\n";
}

package main;

my $obj = new Composite(
    Text => 'Hello World!',
    Mazzi => 'Mazzi',
    Fugi => 'Fugi'
);

# will print
#
# Foo: Mazzi
# Bar: Fugi
# Bar:
# Composite: Hello World!

=h1 Description
   ,   .

=h1 Members

=level 4

=item operator C<new>(@args)

        @args.

=item operator C<surrogate>()

   .

=back

=1 Cavearts

 ,   C<use base>    ,    
 C<Composite>   C<Baz>,   C<Foo>,   
C<Foo>        C<Baz>.   :)

=cut

1;
