package Configuration;
use strict;

my $Configured = 0;

sub import {
    my ($class,$site) = @_;
    
    if ($site and $site ne $Configured) {
        Configure($site);
        $Configured = $site;
    } elsif (not $site and not $Configured) {
        $Configured = 1;
        require Configuration::Global;
    }
}

our %virtualSite;

sub Configure {
    my $siteName = shift;
    require Configuration::Global;
    
    while ( my ($pattern,$configSite) = each %virtualSite) {
        next if not $siteName =~ $pattern;
        if (ref $configSite eq 'CODE') {
            $configSite->();
        } elsif (not ref $configSite and $configSite) {
            require $configSite;
        }
        last;
    }
}



1;
