package Form::Filter;
use strict;
use Common;
our @ISA = qw(Object);

use constant {
    CTX_SINGLE      => 1,   #  
    CTX_SET         => 2,   #  
    CTX_EXISTENT    => 4    #   
};

BEGIN {
    DeclareProperty Name => ACCESS_READ;
    DeclareProperty Message => ACCESS_READ;
}

sub CTOR {
    my ($this,$name,$message) = @_;
    $this->{$Name} = $name or die new Exception('A filter name is required');
    $this->{$Message} = $message;
}

sub FormatMessage {
    my ($this,$object) = @_;
    
    (my $message = $object->Attributes->{$this->{$Name}} || $this->{$Message} || ($Common::Debug ? "$this->{$Name}: %name%" : '')) =~ s{%(\w+(?:\.\w+)*)%}{
        my $value = $object->Attributes->{$1} || ($Common::Debug ? $object->Name.'.'.$1 : '');
    }ge;
    
    return $message;
}

package Form::FilterResult;
use Common;
our @ISA = qw(Object);

use constant {
    STATE_ERROR => 0,           #  
    STATE_SUCCESS => 1,         #  ,   
    STATE_SUCCESS_STOP => 2,    #  ,     
    STATE_SUCCESS_STAY => 3     #  ,      
};

BEGIN {
    DeclareProperty State => ACCESS_READ;
    DeclareProperty Message => ACCESS_READ;
    DeclareProperty Target => ACCESS_READ;
    DeclareProperty Container => ACCESS_READ;
}

sub CTOR {
    my $this = shift;
    $this->SUPER::CTOR(@_);
    
    UNIVERSAL::isa($this->{$Target},'Form::Item') or UNIVERSAL::isa($this->{$Container},'Form::Container') or die new Exception("Invalid Target or Container property") if $this->{$State} == STATE_ERROR;
}

sub Item {
    my $this = shift;
    
    return ref $this->{$Target} ?
        ($this->{$Target}->isa('Form::Item') ? $this->{$Target} : $this->{$Container}->Item( $this->{$Target}->isMulti ? $this->{$Target}->Name . '0' : $this->{$Target}->Name ) )
        :
        ($this->{$Target});
}

1;
