use strict;
package IMPL::SQL::Schema::Type;
use base qw(IMPL::Object IMPL::Object::Autofill);
use IMPL::Class::Property;
use IMPL::Class::Property::Direct;

BEGIN {
    public _direct property Name => prop_get;
    public _direct property MaxLength => prop_get;
    public _direct property Scale => prop_get;
    public _direct property Unsigned => prop_get;
    public _direct property Zerofill => prop_get;
    public _direct property Tag => prop_get;
}

__PACKAGE__->PassThroughArgs;

sub CTOR {
    my $this = shift;
    
    $this->{$Scale} = 0 if not $this->{$Scale};
}

sub isEquals {
    my ($a,$b) = @_;
    
    if (defined $a and defined $b) {
        return $a == $b;
    } else {
        if (defined $a or defined $b) {
            return 0;
        } else {
            return 1;
        }
    }
}

sub isSame {
    my ($this,$other) = @_;
    
    return ($this->{$Name} eq $other->{$Name} and isEquals($this->{$MaxLength},$other->{$MaxLength}) and isEquals($this->{$Scale},$other->{$Scale}));
}

1;
