package IMPL::Security::AbstractRole;
use strict;

use IMPL::Const qw(:prop);

use parent qw(IMPL::Class::Meta);

__PACKAGE__->static_accessor_clone( abstractProps => [
    roleName => PROP_RW,
    parentRoles => PROP_RW | PROP_LIST
]);

sub Satisfy {
    my ($this,@roles) = @_;    
    
    return 1 unless $this->_FilterRoles( @roles );
    return 0;
}

sub _FilterRoles {
    my ($this,@roles) = @_;
    
    @roles = grep not (ref $_ ? $this->roleName eq $_->roleName : $this->roleName eq $_), @roles;
    
    @roles = $_->_FilterRoles(@roles) or return foreach $this->parentRoles ;
    
    return @roles;
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Security::Role> Роль

=head1 DESCRIPTION

Может включать в себя базовые роли.
Имеется метод для проверки наличия необходимых ролей в текущей роли.

=head1 MEMBERS

=over

=item C<[get] roleName>

Имя роли, ее идентификатор

=item C<[get,list] parentRoles>

Список родительских ролей

=item C<Satisfy(@roles_list)>

Проверяет наличие ролей указанных ролей из списка @roles_list.
Допускается использование как самих объектов, так и имен ролей.
Возвращает 0 в случае неудачи (хотябы одна роль не была удовлетворена), 1 при наличии необходимых ролей.

=back

=cut
