package IMPL::Web::Security;
use strict;

use IMPL::Security::Auth qw(:Const);
use IMPL::declare {
    require => {
        Exception => 'IMPL::Exception',
        NotImplementedException => '-IMPL::NotImplementedException',
        SecurityContext => 'IMPL::Security::AbstractContext'
    },
};

sub AuthUser {
    my ($this,$name,$package,$challenge) = @_;
    
    my $user = $this->FindUserByName($name)
        or return { status => AUTH_FAIL, answer => "Can't find a user '$name'" };
    
    my $auth;
    if ( my $secData = $user->GetSecData($package) ) {
        $auth = $package->new($secData);
    } else {
        return {
            status => AUTH_FAIL,
            user => $user
        };
    }
    
    my $status = SecurityContext->current->authority->InitSession(
        $user,
        $auth,
        [$user->roles]
    );
    
    return {
        status => $status,
        user => $user
    };
}

sub FindUserByName {
    die NotImplementedException->new();
}

sub CreateSession {
    die NotImplementedException->new();
}

sub GetSession {
    die NotImplementedException->new();
}

sub SaveSession {
    die NotImplementedException->new();
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::Security> Модуль для аутентификации и авторизации веб запроса.

=head1 DESCRIPTION

Текущий модуль обеспечивает функции верхнего уровня для работы с системой
безопасности. Поскольку модуль является абстрактым, конкретные функции
хранения и реализацию объектов модели безопасности должно обеспечить само
приложение.

Сама система безопасности в веб приложении состоит из двух частей

=over

=item Модель системы безопасности

Предоставляет такие объкты безопасности, как пользователь, сессия роль,
определяет правила проверки прав доступа субъекта к объекту.

=item Модуль безопасности

Как правило встраивается в транспортный уровеь в виде обработчика
C<IMPL::Web::Handler> и реализует непосредственно протокол аутентификации и
обмена с пользователем.

Также модуль безопасности использует модель для хранения сессий и данных
аутентификции. Контекст безопасности создается именно этим модулем.

=back

=head1 MEMBERS

=cut
