package IMPL::Web::View::TTDocument;
use strict;

use Scalar::Util qw(weaken);
use IMPL::Const qw(:prop);
use IMPL::lang qw(:hash is);
use Carp qw(carp);
use mro;
use IMPL::Exception();
use IMPL::declare {
    require => {
    	TTRegistry => 'IMPL::Web::View::TTRegistry',
        TTFactory => 'IMPL::Web::View::TTFactory',
        TTControl =>  'IMPL::Web::View::TTControl',
        Loader => 'IMPL::Code::Loader',
        OpException => '-IMPL::InvalidOperationException'
    },
    base => [
        'IMPL::Web::View::TTControl' => sub {
            my ($template,$ctx,$vars) = @_;
            $ctx ||= Template::Context->new();
            return $template, $ctx, $vars;  # context
        }
    ],
    props => [
        layout => PROP_RW,
        baseLocation => PROP_RW
    ]
};

sub CTOR {
    my ($this,$template,$ctx,$vars) = @_;
    
    $this->layout( $template->layout ) unless $this->layout;
    $this->title( $template->title ) unless $this->title;
    
    $this->context->stash->update($vars)
        if ref $vars eq 'HASH';
}

sub Render {
    my ($this,$args) = @_;

    $args ||= {};
    
    $this->context->localise(); # localise stash
    my $documentContext = _clone_context( $this->context ); # create a new context

    $this->context->stash->update({
    	document => sub { $this }
    });
    
    my $text = eval {
    
        if ($this->layout) {
        	my $tlayout = $this->registry->loader->layout($this->layout)
        	   or die OpException->new('The specified layout isn\'t found', $this->layout);
        	if(my $init = $tlayout->blocks->{INIT}) {
        		$this->context->process(
                    $init,
                    hashMerge(
                        $args,
                        {
                           	template => $this->template
                        }
                    )
                );
        	}
        	my $content = $this->next::method($args);
            return $this->context->include(
                $tlayout,
                {
                	%{$args},
                    content => $content,
                    this => $this,
                    template => $this->template
                }
            );
	    } else {
	        return $this->next::method($args);
	    }
    };
    
    my $e = $@;

    $this->context->delocalise();
    
    undef $this;
    
    if ($e) {
        die $e;
    } else {
        return $text;
    }
}

sub GetTemplate {
    my ($this,$name) = @_;
    
    $this->template->blocks->{$name};
}

sub DTOR {
	my $this = shift;
	
	$this->registry->Dispose() if $this->registry;
}

sub _clone_context {
    my $args = { %{shift || {}} };
    delete $args->{CONFIG};
    
    return Template::Context->new($args);
}

1;

__END__

=pod

=head1 NAME

C<IMPL::Web::View::TTDocument> - документ для построения HTML страницы на основе шаблонов TT.

=head1 SYNOPSIS

=begin code


=end code

=head1 DESCRIPTION


=over


=cut