package IMPL::ORM::Entity;
use strict;
use warnings;

use parent qw(IMPL::Object);
use IMPL::Class::Property;

BEGIN {
    public _direct property Name => prop_get;
    public _direct property Class => prop_get;
    public _direct property Values => prop_get;
    public _direct property Schema => prop_get;
}

sub CTOR {
    my ($this,$class,$schema) = @_;
    
    $this->{$Class} = $class;
    (my $name = $class) =~ s/::/_/g;
    $this->{$Name} = $name;
    $this->Schema = $schema;
    $this->{$Values} = {
        map {$_->{name},{type => $_->{type}, virtual => $_->{virtual}}} @$schema
    };
}

sub Store;
*Store = \&dbgStore;

sub dbgStore {
    my ($this,$prop,$value) = @_;
    
    if ( my $container = $this->{$Values}{$prop} ) {
        $container->{oldValue} = $container->{value};
        $container->{value} = $value;
    } else {
        die new IMPL::InvalidOperationException("Property not found",$this->Name,$prop);
    }
}

sub Get {
    my ($this,$prop) = @_;
    
    return $this->{$Values}{$prop}{value};
}

1;
