package IMPL::Config::Resolve;
use base qw(IMPL::Object IMPL::Object::Autofill IMPL::Object::Serializable);

use IMPL::Class::Property;
use IMPL::Exception;

BEGIN {
	public property target => prop_all;
	public property path => prop_all;
	public property default => prop_all
}

__PACKAGE__->PassThroughArgs;

sub CTOR {
	my ($this) = @_;
	
	die new IMPL::InvalidArgumentException("The argument is mandatory","target") unless $this->target;
	die new IMPL::InvalidArgumentException("The argument is mandatory","path") unless $this->path;
}

sub Invoke {
	my ($this) = @_;
	
	my $path = $this->path;
	
	if (ref $path eq 'ARRAY') {
		my $result = $this->target;
		$result = $this->_InvokeMember($result,$_) || return $this->default foreach @$path;
		return $result;
	} elsif (not ref $path) {
		my $result = $this->target;
		$result = $this->_InvokeMember($result,$_) || return $this->default foreach map { name => $_},split /\./,$this->path;
		return $result;
	} else {
		die new IMPL::InvalidOperationException("Unsopported path type",ref $path);
	}
}

sub _InvokeMember {
	my ($self,$object,$member) = @_;
	
	local $@;
	return eval { $object->($member->{method})(exists $member->{parameters} ? _as_list($member->{parameters}) : ()) };
}

sub _as_list {
	ref $_[0] ?
		(ref $_[0] eq 'HASH' ?
			%{$_[0]}
			:
			(ref $_[0] eq 'ARRAY'?
				@{$_[0]}
				:
				$_[0]
			)
		)
		:
		($_[0]);
}

1;
