package Test::Web::View;
use IMPL::Profiler::Memory;
use strict;
use warnings;
use utf8;

use File::Slurp;
use Scalar::Util qw(weaken);
use Data::Dumper;
use IMPL::lang;
use IMPL::Test qw(assert assertarray test GetCallerSourceLine);

use IMPL::declare {
	require => {
		FormMeta => 'IMPL::Web::View::Metadata::FormMeta',
		Schema => 'IMPL::DOM::Schema',
		Builder => 'IMPL::DOM::Navigator::Builder',
		Document => 'IMPL::DOM::Document',
		XMLReader => 'IMPL::DOM::XMLReader'
	},
	base => [
		'IMPL::Test::Unit' => '@_'
	]
};


sub AssertMemoryLeak {
    my $code = shift;
    my $dump = shift;
    
    my $data = MProfiler->Monitor($code);
    
    if ($data->isLeak and $dump) {
        write_file("dump.out", { binmode => ':utf8' }, $data->Dump() );
    }
    
    assert( not($data->isLeak), "Memory leak detected", GetCallerSourceLine()  , @{$data->{objects}} );    
}

sub templatesDir {
    shift->GetResourceDir('Resources','TTView');
}

test TestFormMetadata => sub {
	my ($this) = @_;
	
	my $schema = Schema->LoadSchema($this->GetResourceFile('Resources','person.schema.xml'));
	my $builder = Builder->new(Document, $schema);
	
	my $reader = XMLReader->new( Navigator => $builder );
	
	$reader->ParseFile("Resources/person_info.xml");
	
	my $doc = $builder->document;
	my @errors = $builder->buildErrors;
	
	push @errors, $schema->Validate($doc);
	
	my $meta = FormMeta->new(
		$doc,
		$doc->schemaSource->type,
		{
			decl => $doc->schemaSource,
			schema => $doc->schema,
			errors => \@errors
		}
	); 

	my $props = $meta->GetProperties;
	
	my $prop = $meta->GetProperty('address');
	
	join ',', map $_->GetProperty('line')->name, @{$prop->GetItems};
};


1;