#!/usr/bin/perl
use strict;

use IMPL::require {
	TTView => 'IMPL::Web::View::TTView'
};

use Time::HiRes qw(gettimeofday tv_interval);

my $t = [gettimeofday];

my $view = TTView->new(
	options => {
		INCLUDE_PATH => './Resources/view',
		INTERPOLATE => 1,
		RECURSION => 1000,
		COMPILE_DIR => '/tmp/ttc'
	},
	viewBase => 'site',
	layoutBase => 'layout',
	layout => 'default',
	includes => [
		'packages'
	]
);

my $model = {
	name => 'debugger',
	manufacture => {
		name => 'DEBUGGERS INC',
		address => [
			{
				coutry => 'Russuia',
				city => 'Moscow'
			},
			{
				country => 'GB',
				city => 'Essex'
			}
		]
	}
}; 

print $view->display(
	$model,
	'product/view'
), "\n";

print "render page: ",tv_interval($t,[gettimeofday]),"s\n";

$t = [gettimeofday];

$view->display(
	$model,
	'product/view'
);

print "2nd render page: ",tv_interval($t,[gettimeofday]),"s\n";

